/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.ui;

import com.ibm.hwmca.base.logon.Logon;
import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.system.CommonSystem;
import com.ibm.hwmca.fw.system.StartupApp;
import com.ibm.hwmca.fw.util.CommonResourceBundle;
import com.ibm.hwmca.fw.util.Trace;
import java.net.InetAddress;
import javax.swing.JApplet;
import javax.swing.UIManager;
import javax.swing.plaf.metal.MetalLookAndFeel;

public class HmcClient
extends JApplet {
    private static final String RES_BUNDLE_BASE_NAME = "com/ibm/hwmca/fw/ui/res/text";
    private static final String TRACE_MASKT = "XFRMHC T";
    private static final String TRACE_MASKF = "XFRMHC F";
    private static final String TRACE_MASKD = "XFRMHC D";
    private String _title;
    private static String _host;
    private static boolean _http;
    private static String _userid;
    private static byte[] _password;
    static HmcClient instance;
    private Logon _logon;
    private boolean _closedPlatform = false;
    private static boolean _shutdown;
    private CommonResourceBundle _resBundle = new CommonResourceBundle();
    private static CommonSystem commonSystem;
    private static final FrameworkClassLogInfo classLogInfo;
    private static final short ERRID_0250 = 592;
    private static final short ERRID_0251 = 593;
    private static final short ERRID_0252 = 594;
    private static final short ERRID_0253 = 595;
    private static final short ERRID_0254 = 596;
    private static final short ERRID_0255 = 597;
    private static final short ERRID_0256 = 598;

    public HmcClient() {
        instance = this;
    }

    public static HmcClient getHmcClient() {
        return instance;
    }

    public void init() {
        try {
            Trace.setDefaultOutput("out");
        }
        catch (Exception exc) {
            Trace.trace(TRACE_MASKF, " error trying to set up out");
        }
        commonSystem.setLocation(2);
        _host = this.getParameter("serverhost");
        commonSystem.setManagerHost(_host);
        String x = this.getParameter("http");
        if (x != null) {
            x = x.toLowerCase();
        }
        if (x != null && (x.equals("true") || x.equals("on") || x.equals("yes"))) {
            _http = true;
        }
        if ((x = this.getParameter("ssl")) != null) {
            x = x.toLowerCase();
        }
        Trace.trace(TRACE_MASKF, " in HmcClient.init");
        Trace.trace(TRACE_MASKF, "   host: " + _host);
        Trace.trace(TRACE_MASKF, "   http: " + _http);
    }

    public void start(String host) {
        Trace.trace(TRACE_MASKF, "in start, server host: " + host);
        _host = host;
        commonSystem.setManagerHost(_host);
        this.start();
    }

    public void start() {
        try {
            boolean clientOnManagerMachine;
            this._title = this.getName() + ":" + this._resBundle.getString("text.hwmca.name");
            InetAddress serverInet = InetAddress.getByName(_host);
            InetAddress loopbackInet = InetAddress.getByName("127.0.0.1");
            InetAddress clientInet = InetAddress.getLocalHost();
            if (serverInet.equals(clientInet) || serverInet.equals(loopbackInet)) {
                Trace.trace(TRACE_MASKF, "  client and server are on the same machine!");
                commonSystem.setClientOnServerMachine(true);
                clientOnManagerMachine = true;
                this._closedPlatform = true;
            } else {
                Trace.trace(TRACE_MASKF, "  client and server are NOT on the same machine!");
                commonSystem.setClientOnServerMachine(false);
                clientOnManagerMachine = false;
            }
            if (clientOnManagerMachine) {
                this.processInitializationHooks();
            }
            this._title = this.getName() + ":" + this._resBundle.getString("text.hwmca.name");
            this.displayLogon();
        }
        catch (Exception exc) {
            this.handleConnectionError(exc);
        }
    }

    private void processInitializationHooks() {
        try {
            StartupApp app = new StartupApp();
            app.runTask();
            Object[] autoLogonData = StartupApp.getAutoLogonData();
            if (autoLogonData[0] != null && autoLogonData[1] != null && _userid == null && _password == null) {
                Trace.trace(TRACE_MASKF, "We think there is auto logon data");
                _userid = (String)autoLogonData[0];
                _password = (byte[])autoLogonData[1];
            }
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKF, "Exception caught processing initialization hooks: " + e);
            new FrameworkLog(classLogInfo, 596, e).log();
        }
    }

    public void displayLogon() {
        boolean logonCanceled = false;
        while (!logonCanceled) {
            this._logon = Logon.getLogon();
            this._logon.logon(_userid, _password);
            _userid = null;
            _password = null;
            if (this._logon.isLogonSuccessful()) {
                String className = "com.ibm.hwmca.hwmcaui.UI";
                try {
                    Class<?> c = Class.forName(className);
                    c.newInstance();
                }
                catch (Exception exc) {
                    Trace.trace(TRACE_MASKF, "  HmcClient caught exception trying to instantiate the user interface.");
                    Trace.trace(TRACE_MASKF, "  The user interface class name is " + className);
                    Trace.trace(TRACE_MASKF, "  Caught exception is: " + exc);
                    new FrameworkLog(classLogInfo, 594, exc).log();
                }
                continue;
            }
            logonCanceled = this._logon.isLogonCanceled();
        }
        System.exit(0);
    }

    protected void handleConnectionError(Throwable exc) {
        if (this._closedPlatform) {
            new FrameworkLog(classLogInfo, 592, exc).log();
        }
        this.shutdown();
    }

    protected void shutdown() {
        if (this._closedPlatform) {
            this.shutdownConsole();
        } else {
            System.exit(0);
        }
    }

    public boolean isClosedPlatform() {
        return this._closedPlatform;
    }

    public String getTitle() {
        return this._title;
    }

    public String getName() {
        return _host;
    }

    public static String getHost() {
        return _host;
    }

    public static boolean isHttp() {
        return _http;
    }

    private void shutdownConsole() {
        if (!_shutdown) {
            System.exit(0);
        }
    }

    public static void main(String[] args) throws Exception {
        String outFileName = "out";
        try {
            UIManager.setLookAndFeel(new MetalLookAndFeel());
            System.setProperty("com.ibm.auiml.DISABLELOOKANDFEELMANAGER", "true");
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKF, "Exception caught, could not establish Metal Look and Feel: " + e);
        }
        commonSystem.setLocation(2);
        boolean useSsl = true;
        int length = args.length;
        int i = 0;
        while (i < length) {
            String parm = args[i];
            if ((parm = parm.toLowerCase()).equals("ssl=true") || parm.equals("ssl=on") || parm.equals("ssl=1") || parm.equals("ssl=yes")) {
                useSsl = true;
            } else if (parm.equals("ssl=false") || parm.equals("ssl=off") || parm.equals("ssl=0") || parm.equals("ssl=no")) {
                useSsl = false;
            } else if (parm.equals("shutdown=false") || parm.equals("shutdown=off") || parm.equals("shutdown=0") || parm.equals("shutdown=no")) {
                _shutdown = false;
            } else if (parm.equals("shutdown=true") || parm.equals("shutdown=on") || parm.equals("shutdown=1") || parm.equals("shutdown=yes")) {
                _shutdown = true;
            } else if (parm.startsWith("host=")) {
                _host = parm.substring(5);
            } else if (parm.startsWith("out=")) {
                outFileName = parm.substring(4);
            } else if (parm.startsWith("userid=")) {
                _userid = parm.substring(7);
            } else if (parm.startsWith("password=")) {
                _password = CommonSystem.getCommonSystem().hashPassword(parm.substring(9));
            }
            ++i;
        }
        Trace.setDefaultOutput(outFileName);
        if (_shutdown) {
            Trace.trace(TRACE_MASKF, "HmcClient.main(), shutdown turned ON");
        } else {
            Trace.trace(TRACE_MASKF, "HmcClient.main(), shutdown turned OFF");
        }
        Trace.trace(TRACE_MASKF, "HmcClient.main(), host is [" + _host + "]");
        Trace.trace(TRACE_MASKF, "HmcClient.main(), will write to " + outFileName);
        Logon.getLogon().getClientUserContext().attachToThread(true);
        HmcClient client = new HmcClient();
        client.start(_host);
    }

    static {
        _http = false;
        _userid = null;
        _password = null;
        _shutdown = false;
        commonSystem = CommonSystem.getCommonSystem();
        classLogInfo = new FrameworkClassLogInfo(85, "HmcClient");
    }
}

